
function GetRectRoundCorner( factory, plane, startinputindex )
{
	if ( plane == null )
		return false;

	var ui = moi.ui;

	var IsRounded = ui.commandUI.rounded.value;
	
	if ( IsRounded )
	{	
		factory.setInput( startinputindex, true );

		ui.beginUIUpdate();
		ui.hideUI( 'LastRectPrompt' );
		ui.hideUI( 'WidthHeight' );
		ui.hideUI( 'rounded' );
		ui.showUI( 'RoundRadius' );
		ui.showUI( 'RoundPrompt' );
		ui.endUIUpdate();

		ui.commandUI.g_RectFactory = factory;

		var pointpicker = ui.createPointPicker();

		pointpicker.bindResultPt( factory.getInput(startinputindex + 1) );
		pointpicker.bindFuncPostUpdate( ui.commandUI.OnRadiusPoint );
		pointpicker.restrictToPlane( plane, true );
		pointpicker.disableStraightSnap = true;
		
		while ( 1 )
		{
			if ( !pointpicker.waitForEvent() )
				return false;
				
			if ( pointpicker.event == 'finished' )
				break;
				
			if ( pointpicker.event == 'roundinput' )
			{
				factory.setInput( startinputindex + 2, ui.commandUI.roundinput.value );
				factory.update();
				break;
			}
		}
	}

	return true;
}
